;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeUserInputUsed2CreateFile.mm
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.1  $
;          $Date:   19 Nov 2007 19:28:58  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeUserInputUsed2CreateFile.mm.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Takes user input (AT BUILD TIME), does this before loading MAKEMSi so
; as to be quick and allow speedy cancellation if user changes mind etc.
;
; You could get much more fancy about how to prompt for the data, for example
; could be a small html application (.hta).
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Get user input (user prompted, but can come from cmd line etc) ---------
;----------------------------------------------------------------------------
#DefineRexx ''
    ;--- Ask for the info ---------------------------------------------------
    call Say ""
    call Say ""
    call Say "NEED CUSTOMERS DETAILS"
    call Say "~~~~~~~~~~~~~~~~~~~~~~"
    call Charout '<stdout>', 'Customer Name : '
    CustomerName = linein('<stdin>');
    call Say2Logs 'CustomerName = "' || CustomerName || '"'
    if CustomerName = '' then
       error 'Build aborted as no customer name supplied';
    call Say ""
    call Say ""

    ;--- Categorise the customer based on what the name is ------------------
    if ToUpperCase(CustomerName) = 'IMPORTANT' then
       CustomerType = "a big wig"
    else
       CustomerType = "small fry"
#DefineRexx


;----------------------------------------------------------------------------
;--- Include MAKEMSI support (with my customisations and MSI branding) ------
;----------------------------------------------------------------------------
#define VER_FILENAME.VER  TryMe.Ver      ;;I only want one VER file for all samples! (this line not actually required in "tryme.mm")
#include "ME.MMH"


;----------------------------------------------------------------------------
;--- Create the file (contents vary by customer) ----------------------------
;----------------------------------------------------------------------------
<$FileMake "out\Customer.dat">
    This data file is for "<??CustomerName>" and was created <?CompileTime>
    by <??*UserName>.

    <?NewLine>
    This customer is <??CustomerType>...
<$/FileMake>

;----------------------------------------------------------------------------
;--- Define default location where file should install and add files --------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="[ProgramFilesFolder]\<$ProdInfo.ProductName>" CHANGE="\" PrimaryFolder="Y">
<$Files "out\Customer.dat" DestDir="INSTALLDIR">

